/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logon;

import com.ibm.hwmca.base.logon.Logon;
import com.ibm.hwmca.base.logon.LogonConstants;
import com.ibm.hwmca.base.logon.LogonErrorIds;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.connmgr.DisabledUseridException;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.connmgr.PasswordExpiredException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.ui.HmcClient;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;

public class LogonBean
extends PanelBean
implements LogonConstants,
LogonErrorIds {
    private static final String TRACE_MASKT = "XLGNBENT";
    private static final String TRACE_MASKF = "XLGNBENF";
    private static final String TRACE_MASKD = "XLGNBEND";
    private static final String LOGON_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private static final String USERID_REQUIRED_ERROR_TEXT = "LGN.LOGON.REQUIRED.USERID.ERROR.TEXT";
    private static final String INVALID_USERID_ERROR_TEXT = "LGN.LOGON.INVALID.USERID.TEXT";
    private static final String PASSWORD_REQUIRED_ERROR_TEXT = "LGN.LOGON.REQUIRED.PASSWORD.ERROR.TEXT";
    private static final String INVALID_PASSWORD_ERROR_TEXT = "LGN.LOGON.INVALID.PASSWORD.TEXT";
    private static final String DISABLED_USERID_ERROR_TITLE = "LGN.LOGON.DISABLED.USERID.ERROR.TITLE";
    private static final String DISABLED_USERID_ERROR_TEXT = "LGN.LOGON.DISABLED.USERID.ERROR.TEXT";
    private static final String LOGON_FAILED_TITLE = "LGN.LOGON.FAILED.TITLE";
    private static final String LOGON_FAILED_TEXT = "LGN.LOGON.FAILED.TEXT";
    private static final String LOGON_FAILED3_TITLE = "LGN.LOGON.FAILED3.TITLE";
    private static final String LOGON_FAILED3_TEXT = "LGN.LOGON.FAILED3.TEXT";
    private static final String WHITE_MSGS_FILE = "com/ibm/hwmca/fw/images/whtmsgs.gif";
    private static final String BLUE_HW_MSGS_FILE = "com/ibm/hwmca/fw/images/bluehwmsgs.gif";
    private static final String CYAN_OS_MSGS_FILE = "com/ibm/hwmca/fw/images/cyanosmsgs.gif";
    private static final String ACCEPTABLE_STATUS_BAR = "<html><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" ><tr style=\"background-color: #008000\" ><TD width=\"540\" height=\"40\" ></TD></tr></table></html>";
    private static final String UNACCEPTABLE_STATUS_BAR = "<html><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" ><tr style=\"background-color: #FF0000\" ><TD width=\"540\" height=\"40\" ></TD></tr></table></html>";
    private Integer[] useridLengths = new Integer[]{new Integer(4), new Integer(32)};
    private Integer[] passwordLengths = new Integer[]{new Integer(6), new Integer(32)};
    public static final String LOGON_PANEL_TASKLET = "com.ibm.hwmca.base.logon.LogonTasklet";
    private String m_sUserIdentificationEdit;
    private String m_sPasswordEdit;
    private String m_sUserStyleChoice;
    private ValueDescriptor[] m_cdUserStyleChoice;
    private boolean closedPlatform;
    private boolean disabledUserid;
    private boolean passwordExpired;
    private String title;
    private int logonFailedCounter = 0;
    private HmcClient hmcClient;
    private Logon logon;

    public void setUserIdentificationEdit(String userid) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> LogonBean.setUserIdentificationEdit()");
        if (userid.length() > 0) {
            if (userid.length() < 4 || userid.length() > 32) {
                this.m_sUserIdentificationEdit = "";
                this.m_sPasswordEdit = "";
                this.userTaskManager.refreshElement(this.getMountPrefix() + "UserIdentificationEdit");
                this.userTaskManager.refreshElement(this.getMountPrefix() + "PasswordEdit");
                throw new IllegalUserDataException(new LocalizableText(LOGON_MESSAGES_FILENAME, INVALID_USERID_ERROR_TEXT, this.useridLengths).toString());
            }
        } else {
            this.m_sUserIdentificationEdit = "";
            this.m_sPasswordEdit = "";
            this.userTaskManager.refreshElement(this.getMountPrefix() + "UserIdentificationEdit");
            this.userTaskManager.refreshElement(this.getMountPrefix() + "PasswordEdit");
            throw new IllegalUserDataException(new LocalizableText(LOGON_MESSAGES_FILENAME, USERID_REQUIRED_ERROR_TEXT).toString());
        }
        this.m_sUserIdentificationEdit = userid.toUpperCase();
        this.userTaskManager.refreshElement("UserIdentificationEdit");
        Trace.trace(TRACE_MASKT, "<- LogonBean.setUserIdentificationEdit()");
    }

    public String getUserIdentificationEdit() {
        Trace.trace(TRACE_MASKT, "<> LogonBean.getUserIdentificationEdit()");
        return this.m_sUserIdentificationEdit;
    }

    public void setPasswordEdit(String password) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> LogonBean.setPasswordEdit()");
        if (password.length() > 0) {
            if (password.length() < 6 || password.length() > 32) {
                this.m_sPasswordEdit = "";
                this.userTaskManager.refreshElement(this.getMountPrefix() + "PasswordEdit");
                throw new IllegalUserDataException(new LocalizableText(LOGON_MESSAGES_FILENAME, INVALID_PASSWORD_ERROR_TEXT, this.passwordLengths).toString());
            }
        } else {
            this.m_sPasswordEdit = "";
            this.userTaskManager.refreshElement(this.getMountPrefix() + "PasswordEdit");
            throw new IllegalUserDataException(new LocalizableText(LOGON_MESSAGES_FILENAME, PASSWORD_REQUIRED_ERROR_TEXT).toString());
        }
        this.m_sPasswordEdit = password.toUpperCase();
        this.userTaskManager.refreshElement("PasswordEdit");
        Trace.trace(TRACE_MASKT, "<- LogonBean.setPasswordEdit()");
    }

    public String getPasswordEdit() {
        Trace.trace(TRACE_MASKT, "<> LogonBean.getPasswordEdit()");
        return this.m_sPasswordEdit;
    }

    public String getUserStyleChoice() {
        Trace.trace(TRACE_MASKT, "<> LogonBean.getUserStyleChoice()");
        return this.m_sUserStyleChoice;
    }

    public void setUserStyleChoice(String uiStyle) {
        Trace.trace(TRACE_MASKT, "-> LogonBean.setUserStyleChoice()");
        this.m_sUserStyleChoice = uiStyle;
        Trace.trace(TRACE_MASKT, "<- LogonBean.setUserStyleChoice()");
    }

    public ValueDescriptor[] getUserStyleChoiceList() {
        Trace.trace(TRACE_MASKT, "<> LogonBean.getUserStyleChoiceList()");
        return this.m_cdUserStyleChoice;
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> LogonBean.load()");
        this.m_cdUserStyleChoice = new ValueDescriptor[0];
        this.m_sUserStyleChoice = "";
        this.m_sUserIdentificationEdit = "";
        this.m_sPasswordEdit = "";
        Trace.trace(TRACE_MASKT, "<- LogonBean.load()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> LogonBean.prepare()");
        this.logon = Logon.getLogon();
        this.hmcClient = HmcClient.getHmcClient();
        this.closedPlatform = this.hmcClient.isClosedPlatform();
        this.title = this.hmcClient.getTitle();
        this.userTaskManager.setCaptionText(this.getMountPrefix() + "HMCLogonPanel", this.title);
        this.userTaskManager.setShown(this.getMountPrefix() + "UserInterStyleGB", false);
        this.resetLogon();
        if (this.closedPlatform) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("SOURCE", "PREPARE");
            this.postTaskletRequest(request);
        } else {
            this.userTaskManager.setShown(this.getMountPrefix() + "StatusIndicatorGB", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "MessageIndicatorsGB", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "ShutdownCancelButton", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "CancelButton", true);
        }
        Trace.trace(TRACE_MASKT, "<- LogonBean.prepare()");
    }

    public void update(Object o) {
        Trace.trace(TRACE_MASKT, "-> LogonBean.update()");
        PanelTaskletRequest request = (PanelTaskletRequest)o;
        String source = (String)request.getData("SOURCE");
        if (source.equals("PROPERTY_CHANGE")) {
            String propertyName = (String)request.getData("PROPERTY_NAME");
            boolean newValue = (Boolean)request.getData("NEW_VALUE");
            if (propertyName.equals("StatusAcceptable")) {
                this.setStatusBar(newValue);
            } else if (propertyName.equals("HWMessagesExistProperty")) {
                this.setHWMessages(newValue);
            } else if (propertyName.equals("OSMessagesExistProperty")) {
                this.setOSMessages(newValue);
            }
        } else if (source.equals("CLEAR")) {
            this.load();
            this.userTaskManager.refreshAllElements();
            this.resetLogon();
        }
        Trace.trace(TRACE_MASKT, "<- LogonBean.update()");
    }

    public void verifyChanges() {
        Trace.trace(TRACE_MASKT, "<> LogonBean.verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> LogonBean.save()");
    }

    public void panelAction(TaskActionEvent event) {
        IllegalUserDataException uiExc;
        block17: {
            Trace.trace(TRACE_MASKT, "-> LogonBean.panelAction(" + event + ")");
            uiExc = null;
            String elementName = event.getElementName();
            try {
                if (elementName.equals(this.getMountPrefix() + "LogonButton") || elementName.equals(this.getMountPrefix() + "ChangePasswordButton")) {
                    Trace.trace(TRACE_MASKF, "LogonBean.panelAction(): elementName = " + elementName);
                    this.userTaskManager.storeElement(this.getMountPrefix() + "UserIdentificationEdit");
                    this.userTaskManager.storeElement(this.getMountPrefix() + "PasswordEdit");
                    if (this.logon(this.m_sUserIdentificationEdit, this.m_sPasswordEdit)) {
                        this.logonFailedCounter = 0;
                        this.logon.setLogonResult(2);
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setData("SOURCE", "HMCLogonPanel");
                        request.setData("EVENT", event);
                        Boolean platform = new Boolean(this.closedPlatform);
                        request.setData("PLATFORM", platform);
                        request.setData("USERID", this.m_sUserIdentificationEdit);
                        this.postTaskletRequest(request);
                        break block17;
                    }
                    this.logon.setLogonResult(0);
                    if (this.disabledUserid) {
                        try {
                            LocalizableText disabled_userid_error = CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText(LOGON_MESSAGES_FILENAME, DISABLED_USERID_ERROR_TITLE), new MessageText(LOGON_MESSAGES_FILENAME, DISABLED_USERID_ERROR_TEXT));
                        }
                        catch (Exception exc) {
                            Trace.trace(TRACE_MASKF, exc);
                        }
                    } else {
                        ++this.logonFailedCounter;
                        if (this.logonFailedCounter < 3) {
                            try {
                                LocalizableText ans = CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText(LOGON_MESSAGES_FILENAME, LOGON_FAILED_TITLE), new MessageText(LOGON_MESSAGES_FILENAME, LOGON_FAILED_TEXT));
                            }
                            catch (Exception exc) {
                                Trace.trace(TRACE_MASKF, exc);
                            }
                        } else {
                            try {
                                LocalizableText ans = CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText(LOGON_MESSAGES_FILENAME, LOGON_FAILED3_TITLE), new MessageText(LOGON_MESSAGES_FILENAME, LOGON_FAILED3_TEXT));
                            }
                            catch (Exception exc) {
                                Trace.trace(TRACE_MASKF, exc);
                            }
                            this.userTaskManager.setEnabled(this.getMountPrefix() + "LogonButton", false);
                            this.userTaskManager.setEnabled(this.getMountPrefix() + "ChangePasswordButton", false);
                            Timer timer = new Timer();
                            TimerTask task = new TimerTask(){

                                public void run() {
                                    LogonBean.this.userTaskManager.setEnabled(LogonBean.this.getMountPrefix() + "LogonButton", true);
                                    LogonBean.this.userTaskManager.setEnabled(LogonBean.this.getMountPrefix() + "ChangePasswordButton", true);
                                }
                            };
                            timer.schedule(task, 30000L);
                        }
                    }
                    this.load();
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "PasswordEdit");
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "UserIdentificationEdit");
                    break block17;
                }
                if (elementName.equals(this.getMountPrefix() + "ShutdownCancelButton") || elementName.equals(this.getMountPrefix() + "CancelButton")) {
                    Trace.trace(TRACE_MASKF, "LogonBean.panelAction(): elementName = " + elementName);
                    uiExc = new IllegalUserDataException();
                    if (!this.closedPlatform) {
                        this.logon.setLogonResult(1);
                    }
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("SOURCE", "HMCLogonPanel");
                    request.setData("EVENT", event);
                    Boolean platform = new Boolean(this.closedPlatform);
                    request.setData("PLATFORM", platform);
                    this.postTaskletRequest(request);
                }
            }
            catch (IllegalUserDataException iuExc) {
                Trace.trace(TRACE_MASKF, "LogonBean.panelAction(): " + (Object)((Object)iuExc));
            }
        }
        if (uiExc != null) {
            throw uiExc;
        }
        Trace.trace(TRACE_MASKT, "<- LogonBean.panelAction()");
    }

    private boolean logon(String userid, String password) {
        Trace.trace(TRACE_MASKT, "-> LogonBean.logon()");
        boolean result = false;
        this.disabledUserid = false;
        try {
            ConnectionFactory connectionfactory = Logon.getLogon().getClientUserContext().getConnectionFactory();
            for (int retryLogonCount = 0; retryLogonCount < 3; ++retryLogonCount) {
                try {
                    connectionfactory.setUserAndPassword(userid, CommonSystem.getCommonSystem().hashPassword(password));
                    result = true;
                    break;
                }
                catch (UnknownHostException exc) {
                    new FrameworkLog(LogonErrorIds.LOGINFO, 98, exc).log();
                    break;
                }
                catch (ClassNotFoundException exc) {
                    new FrameworkLog(LogonErrorIds.LOGINFO, 98, exc).log();
                    break;
                }
                catch (InvalidPasswordException exc) {
                    break;
                }
                catch (DisabledUseridException exc) {
                    this.disabledUserid = true;
                    break;
                }
                catch (PasswordExpiredException exc) {
                    this.passwordExpired = true;
                    break;
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKD, "LogonBean.logon(): Attempting to retry the logon");
                    continue;
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(LogonErrorIds.LOGINFO, 99, exc).log();
        }
        Trace.trace(TRACE_MASKT, "<- LogonBean.logon()");
        return result;
    }

    private boolean resetLogon() {
        Trace.trace(TRACE_MASKT, "-> LogonBean.resetLogon()");
        boolean resetResult = false;
        try {
            ConnectionFactory connectionfactory = Logon.getLogon().getClientUserContext().getConnectionFactory();
            for (int retryResetLogonCount = 0; retryResetLogonCount < 3; ++retryResetLogonCount) {
                try {
                    connectionfactory.resetUserAndPassword();
                    resetResult = true;
                    break;
                }
                catch (UnknownHostException exc) {
                    Trace.trace(TRACE_MASKF, exc);
                    break;
                }
                catch (ClassNotFoundException exc) {
                    Trace.trace(TRACE_MASKF, exc);
                    break;
                }
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, exc);
                    continue;
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(LogonErrorIds.LOGINFO, 99, exc).log();
        }
        Trace.trace(TRACE_MASKT, "<- LogonBean.resetLogon()");
        return resetResult;
    }

    private void setStatusBar(boolean newValue) {
        Trace.trace(TRACE_MASKT, "-> LogonBean.setStatusBar(" + newValue + ")");
        if (newValue) {
            this.userTaskManager.setCaptionText(this.getMountPrefix() + "StatusImageLabel", ACCEPTABLE_STATUS_BAR);
        } else {
            this.userTaskManager.setCaptionText(this.getMountPrefix() + "StatusImageLabel", UNACCEPTABLE_STATUS_BAR);
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + "StatusIndicatorGB");
        Trace.trace(TRACE_MASKT, "<- LogonBean.setStatusBar()");
    }

    private void setHWMessages(boolean newValue) {
        Trace.trace(TRACE_MASKT, "-> LogonBean.setHWMessages(" + newValue + ")");
        if (newValue) {
            this.userTaskManager.setCaptionImageSrc(this.getMountPrefix() + "HWMessagesImageLabel", BLUE_HW_MSGS_FILE);
        } else {
            this.userTaskManager.setCaptionImageSrc(this.getMountPrefix() + "HWMessagesImageLabel", WHITE_MSGS_FILE);
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + "HWMessageGB");
        Trace.trace(TRACE_MASKT, "<- LogonBean.setHWMessages()");
    }

    private void setOSMessages(boolean newValue) {
        Trace.trace(TRACE_MASKT, "-> LogonBean.setOSMessages(" + newValue + ")");
        if (newValue) {
            this.userTaskManager.setCaptionImageSrc(this.getMountPrefix() + "OpSysMessageImageLabel", CYAN_OS_MSGS_FILE);
        } else {
            this.userTaskManager.setCaptionImageSrc(this.getMountPrefix() + "OpSysMessageImageLabel", WHITE_MSGS_FILE);
        }
        this.userTaskManager.refreshElement(this.getMountPrefix() + "OSMessageGB");
        Trace.trace(TRACE_MASKT, "<- LogonBean.setOSMessages()");
    }
}

